#include "AD18F08.h"
#include <stdio.h>
#include <string.h>
#include "usart.h"
#include "periph.h"

void usart_init()
{
    TX_DIR=0; 
    TX_PIN=1;
    RX_DIR=1;
    RX_RU=0;
}

/*
// Baud  = 9600
*/
void putch(unsigned char tmp)
{
    unsigned char i=0;
    GIE = 0;
    TX_PIN = 1;
    TX_PIN = 0; //START
    __delay_us(104);	
    for(i=0;i<8;i++)
    {
        TX_PIN=tmp&0X01;
        __delay_us(100);
        tmp=tmp>>1;
    }
    TX_PIN = 1;     //stop
    __delay_us(104);
    __delay_us(104);
    GIE = 1;
}


unsigned char getch(void)
{
    unsigned char tmp=0;
    while(RX_PIN==1);

    __delay_us(104);
    __delay_us(52);
    if (RX_PIN==1)
        tmp = tmp | 0x01;	
    __delay_us(104);  //1

    if (RX_PIN==1)
        tmp = tmp | 0x02;			
    __delay_us(104);  //2

    if (RX_PIN==1)
        tmp = tmp | 0x04;
    __delay_us(104);  //3

    if (RX_PIN==1)
        tmp = tmp | 0x08;	
    __delay_us(104);  //4

    if (RX_PIN==1)
        tmp = tmp | 0x10;			
    __delay_us(104);  //5

    if (RX_PIN==1)
        tmp = tmp | 0x20;			
    __delay_us(104);  //6

    if (RX_PIN==1)
        tmp = tmp | 0x40;			
    __delay_us(104);  //7

    if (RX_PIN==1)
        tmp = tmp | 0x80;			
    __delay_us(104);  //7
    
    if (RX_PIN==1)
        return tmp; //stop
    else
        return 0;
    
}
